package ai.accurat.sdk.callbacks;

/**
 * Interface to be used when you need a different call for completion and follow-up actions.
 *
 * @Accurat
 * @since 2.0.0
 */
public interface AccuratActionableCallback extends AccuratCompletionCallback {
    /**
     * Indicates successful completion of the action, but does not call for action.
     *
     * @param success Whether the action has been completed successfully.
     */
    @Override
    void onCompleted(boolean success);

    /**
     * Will be called when the caller thinks an action might be required or is at least appropriate by the subscriber.
     * e.g. when data has been fetched and stored in the database or changes have been applied to settings
     * <p>
     * {@link #onCompleted(boolean)} for this class will only indicate successful completion of the action.
     *
     * @param isActionRequired Indicates whether the caller thinks an action might be required.
     */
    void onActionPotentiallyRequired(final boolean isActionRequired);
}
