package ai.accurat.sdk.core;

import java.util.HashMap;

import ai.accurat.sdk.config.Configuration;

/**
 * @author Kenneth Saey
 * @since 02-07-2018 14:16.
 *
 * @Accurat
 */
public class AccuratEndpoint {

    private String route;

    public AccuratEndpoint(String route) {
        this.route = route;
    }

    public String getUrl() {
        return getUrl(null);
    }

    public String getUrl(HashMap<String, Object> urlParameters) {
        return Configuration.ACCURAT_API_DOMAIN + getPath(urlParameters);
    }

    public String getPath() {
        return getPath(null);
    }

    public String getPath(HashMap<String, Object> urlParameters) {
        String url = "/" + Configuration.ACCURAT_API_PATH
                + "/" + Configuration.ACCURAT_API_VERSION
                + "/" + route;
        if(urlParameters != null) {
            for (String key : urlParameters.keySet()) {
                if(key == null || key.isEmpty()) {
                    continue;
                }

                Object value = urlParameters.get(key);
                if(value == null) {
                    value = "";
                }

                url = url.replaceFirst(":" + key, value.toString());
            }
        }

        return url;
    }
}
