package ai.accurat.sdk.core;

class AccuratGeofenceRange {
    private Double latitudeRange;
    private Double longitudeRange;

    public AccuratGeofenceRange(Double latitudeRange, Double longitudeRange) {
        this.latitudeRange = latitudeRange;
        this.longitudeRange = longitudeRange;
    }

    public Double getLatitudeRange() {
        return latitudeRange;
    }

    public Double getLongitudeRange() {
        return longitudeRange;
    }

    public Double convertToDistance() {
        Double currentDistance = (this.latitudeRange / GeofencesManager.DISTANCE_CONVERSION_LATITUDE) * GeofencesManager.DISTANCE_CONVERSION_METER;
        Double newDistance = currentDistance - GeofencesManager.ERROR_MARGIN;
        return newDistance < GeofencesManager.MIN_META_GEOFENCE_RANGE
                ? GeofencesManager.MIN_META_GEOFENCE_RANGE
                : newDistance;

    }
}
