package ai.accurat.sdk.core;

import com.google.android.gms.ads.identifier.AdvertisingIdClient;

import java.util.Date;

/**
 * Builder implementation to create {@link AccuratLocation} objects.
 * Should be a carbon copy of the original OpenLocateLocation implementation.
 *
 * @since 2.0.0
 */
public class AccuratLocationBuilder implements AccuratLocationBuilderInterface {

    private Date created;
    private android.location.Location location;
    private AdvertisingIdClient.Info advertisingInfo;
    private InformationFields informationFields;
    private UserActivity userActivity;
    private String jsonRepresentation;
    private LocationInfo locationInfo;

    @Override
    public AccuratLocationBuilder setDate(Date date) {
        this.created = date;
        return this;
    }

    @Override
    public AccuratLocationBuilder setLocation(android.location.Location location) {
        this.location = location;
        return this;
    }

    @Override
    public AccuratLocationBuilderInterface setLocationInfo(LocationInfo locationInfo) {
        this.locationInfo = locationInfo;
        return this;
    }

    @Override
    public AccuratLocationBuilder setAdvertisingInfo(AdvertisingIdClient.Info advertisingInfo) {
        this.advertisingInfo = advertisingInfo;
        return this;
    }

    @Override
    public AccuratLocationBuilder setInformationFields(InformationFields informationFields) {
        this.informationFields = informationFields;
        if (informationFields != null) {
            this.userActivity = informationFields.getUserActivity();
        }
        return this;
    }

    @Override
    public AccuratLocationBuilder setUserActivity(UserActivity userActivity) {
        this.userActivity = userActivity;
        return this;
    }

    @Override
    public AccuratLocationBuilder setJsonRepresentation(String jsonRepresentation) {
        this.jsonRepresentation = jsonRepresentation;

        return this;
    }

    public AccuratLocation build() {
        return this.created == null
                ? new AccuratLocation(this.location, this.advertisingInfo, this.informationFields, this.userActivity)
                : new AccuratLocation(this.created, this.jsonRepresentation);
    }
}
