package ai.accurat.sdk.core

import android.content.Context
import androidx.work.Worker
import androidx.work.WorkerParameters

/**
 * @author Kenneth
 * @since 2021-10-26
 */
class CampaignUploadWorker(context: Context, workerParams: WorkerParameters) :
    Worker(context, workerParams) {

    companion object {
        private val TAG = CampaignUploadWorker::class.java.simpleName
    }

    override fun doWork(): Result {
        AccuratLogger.init(applicationContext)
        AccuratLogger.log(AccuratLogger.WORKMANAGER, "$TAG.doWork()")
        CampaignManager.init(applicationContext)

        AccuratLogger.log(AccuratLogger.SDK_FLOW, "Starting async campaign interactions upload")
        CampaignManager.upload(true) { success ->
            val result = if (success) "succeeded" else "failed"
            AccuratLogger.log(AccuratLogger.SDK_FLOW, "Async campaign interactions $result")
            AccuratLogger.log(AccuratLogger.WORKMANAGER, "$TAG - Work done")
        }

        return Result.success()
    }
}