/*
 * Copyright (c) 2017 OpenLocate
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package ai.accurat.sdk.core;

import ai.accurat.sdk.config.Configuration;

/**
 * @Both
 */
final class Constants {

    // Default Location constants
    static final long DEFAULT_LOCATION_INTERVAL_SEC = Configuration.DEFAULT_LOCATION_INTERVAL;
    static final long DEFAULT_FAST_LOCATION_INTERVAL_SEC = 60;// Every minute
    static final long DEFAULT_TRANSMISSION_INTERVAL_SEC = Configuration.DEFAULT_TRANSMISSION_INTERVAL_IN_SECS;
    static final long SERVICE_CHECK_INTERVAL_MSEC = 5 * 60 * 1000;
    static final LocationAccuracy DEFAULT_LOCATION_ACCURACY = LocationAccuracy.HIGH;
    static final long MAX_WAIT_TIME_SEC = Configuration.DEFAULT_MAX_WAIT_TIME;
    static final long SMALLEST_DISPLACEMENT = Configuration.DEFAULT_SMALLEST_DISPLACEMENT;

    static final long LOCATION_RESET_TIMEOUT = 5400;// 90 minutes

    // Location service intent keys
    static final String ENDPOINTS_KEY = "endpoints";
    static final String SERVICE_STATUS = "service_status";
    static final String TRACKING_STATUS = "tracking_status";

    static final String LOCATION_ACCURACY_KEY = "location_accuracy";
    static final String LOCATION_INTERVAL_KEY = "location_interval";
    static final String SMALLEST_DISPLACEMENT_KEY = "smallest_displacement";
    static final String MAX_WAIT_TIME_KEY = "max_wait_time";
    static final String TRANSMISSION_INTERVAL_KEY = "transmission_interval";
    static final String INTENT_CONFIGURATION = "intent_configuration";

    static final String ADVERTISING_ID_KEY = "advertising_id";
    static final String LIMITED_AD_TRACKING_ENABLED_KEY = "limited_ad_tracking_enabled";

    static final int DEFAULT_PORT = -1;

    // Local broadcast manager event names
    static final String LOCATION_INTERVAL_CHANGED = Constants.class.getCanonicalName() + ".LocationIntervalChanged";
    static final String LOCATION_ACCURACY_CHANGED = Constants.class.getCanonicalName() + ".LocationAccuracyChanged";
    static final String TRANSMISSION_INTERVAL_CHANGED = Constants.class.getCanonicalName() + ".TransmissionIntervalChanged";
    static final String SMALLEST_DISPLACEMENT_CHANGED = Constants.class.getCanonicalName() + ".SmallestDisplacementChanged";
    static final String MAX_WAIT_TIME_CHANGED = Constants.class.getCanonicalName() + ".MaxWaitTimeChanged";

    public static final String OPENLOCATE = "com.openlocate.android";
    public static final String IS_SERVICE_STARTED = "is_service_running";

    static final String SENT_TIMESTAMPS_KEY = "last_sent_timestamps";
    static final String DISPATCH_ENDPOINT_KEY = "dispatch_endpoint_key";
    static final String DISPATCH_LAST_SENT_TIMESTAMP = "dispatch_last_sent_timestamp";
    static final String DISPATCH_WORK_TAG = "accurat_dispatch_work";
    static final String RESTART_TRACKING_WORK_TAG = "accurat_restart_tracking";
    static final String SYNC_SETTINGS_WORK_TAG = "accurat_sync_settings_work";
    static final String LAST_LOCATION_TIMESTAMP = "last_location_timestamp";
    static final String LOCATION_RESTART_TIMEOUT = "location_restart_timeout";
    static final String SYNC_GEOFENCES_NOTIFICATIONS_WORK_TAG = "accurat_geofences_notifications_settings_work";
    static final String UPLOAD_CAMPAIGN_WORK_TAG = "accurat_upload_campaign_work";

    // <editor-fold desc="Custom Geofences">
    static final float CUSTOM_GEOFENCE_DEFAULT_HORIZONTAL_ACCURACY_BOUNDARY = 75;// 75 meters
    static final double CUSTOM_GEOFENCE_DEFAULT_DISPLACEMENT_BOUNDARY = 20;// 20 meters
    static final double CUSTOM_GEOFENCE_DEFAULT_SPEED_BOUNDARY = 40 / 3.6;// 40 km/h in m/s
    static final int CUSTOM_GEOFENCE_DEFAULT_GEOFENCE_THROTTLE = 5;// 5 seconds
    // </editor-fold>
}
