package ai.accurat.sdk.core;

import android.content.Context;

import ai.accurat.sdk.callbacks.AccuratProcessCallback;

/**
 * Interface for abstracting location dispatching.
 * This could entail an upload of the location collection to the server and more.
 */
public interface DispatcherInterface {

    /**
     * Initializes the location dispatcher.
     */
    void initDispatcher(Context context);

    /**
     * Start dispatching the location.
     *
     * @param callback Callback to communicate whether dispatching succeeded.
     * @return true when the dispatcher has been started correctly.
     */
    boolean startDispatcher(AccuratProcessCallback callback);

    /**
     * Stops the dispatcher.
     *
     * @param context The current context
     */
    void stopDispatcher(Context context);

}
