package ai.accurat.sdk.core;

import java.util.List;

/**
 * Interface for defining the functions available for geofence storage and the management thereof.
 */
interface GeofenceDataSource {
    void addGeofences(List<AccuratGeofence> geofences);

    long getNumberOfGeofences();

    List<AccuratGeofence> getGeofences();

    List<AccuratGeofence> getGeofencesWithinBox(LocationInterface location, AccuratGeofenceRange box);

    List<AccuratGeofence> getGeofencesWithinBox(SearchBox searchBox);

    List<AccuratGeofence> getRecentGeofences(int limit);

    AccuratGeofence getGeofenceById(String serverId);

    long removeGeofences();
}
