package ai.accurat.sdk.core;

import org.json.JSONException;
import org.json.JSONObject;

import ai.accurat.sdk.constants.ServerDataKeys;

/**
 * @author Kenneth
 * @since 2020-09-08
 */
public class Meta extends JSON {

    // <editor-fold desc="Properties">
    private static final String TAG = Meta.class.getSimpleName();
    public String key;
    public String value;
    // </editor-fold>

    // <editor-fold desc="Initialisation">
    public Meta() {
    }

    public Meta(String key, String value) {
        this.key = key;
        this.value = value;
    }
    // </editor-fold>

    // <editor-fold desc="JSON Handling">
    @Override
    public void update(JSONObject json) {
        key = load(json, ServerDataKeys.Meta.KEY, key);
        value = load(json, ServerDataKeys.Meta.VALUE, value);
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        try {
            json.put(ServerDataKeys.Meta.KEY, key);
            json.put(ServerDataKeys.Meta.VALUE, value);
        } catch (JSONException e) {
            AccuratLogger.log(AccuratLogger.JSON_ERROR, TAG + ".toJson(): " + e.getMessage());
            e.printStackTrace();
        }

        return json;
    }
    // </editor-fold>
}
