package ai.accurat.sdk.core;

import android.annotation.TargetApi;
import android.os.Build;

/**
 * Defines a search area.
 * Uses older APIs not used for {@link SearchBox}.
 */
@TargetApi(Build.VERSION_CODES.KITKAT)
class SearchBoxKitKat implements SearchBoxInterface {

    private Double minLatitude;
    private Double maxLatitude;
    private Double minLongitude;
    private Double maxLongitude;

    SearchBoxKitKat(Double minLatitude, Double maxLatitude, Double minLongitude, Double maxLongitude) {
        this.minLatitude = minLatitude;
        this.maxLatitude = maxLatitude;
        this.minLongitude = minLongitude;
        this.maxLongitude = maxLongitude;
    }

    /**
     * Determines whether a geofence is within this search box.
     *
     * @param geofence geofence to verify the location of.
     * @return True when within the search box, false if not.
     */
    @Override
    public boolean isWithinRange(AccuratGeofence geofence) {
        return geofence != null
                && this.minLatitude <= geofence.getLatitude()
                && this.maxLatitude >= geofence.getLatitude()
                && this.minLongitude <= geofence.getLongitude()
                && this.maxLongitude >= geofence.getLongitude();
    }
}
