package ai.accurat.sdk.core;

import com.google.android.gms.location.DetectedActivity;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.Serializable;

import ai.accurat.sdk.constants.StorageKeys;

/**
 * Carbon copy of OpenLocateLocation.UserActivity.
 * Extracted for reuse with different location tracking platforms.
 *
 * @since 2.0.0
 */
public class UserActivity extends JSON implements Serializable {

    private static final String TAG = UserActivity.class.getSimpleName();
    private String type = UserActivityType.UNKNOWN.toString();
    private int confidence = 0;

    public UserActivity(JSONObject json) {
        update(json);
    }

    UserActivity(String type, int confidence) {
        this.type = type;
        this.confidence = confidence;
    }

    UserActivity(DetectedActivity activity) {
        type = UserActivityType.fromApiValue(activity.getType()).toString();
        confidence = activity.getConfidence();
    }

    UserActivity(int activityType) {
        type = UserActivityType.fromApiValue(activityType).toString();
        confidence = 1;
    }

    public UserActivity() {
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getConfidence() {
        return confidence;
    }

    public void setConfidence(int confidence) {
        this.confidence = confidence;
    }

    // <editor-fold desc="JSON Handling">
    @Override
    public void update(JSONObject json) {
        type = load(json, StorageKeys.UserActivity.TYPE, type);
        confidence = load(json, StorageKeys.UserActivity.CONFIDENCE, confidence);
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        try {
            json.put(StorageKeys.UserActivity.TYPE, type);
            json.put(StorageKeys.UserActivity.CONFIDENCE, confidence);
        } catch (JSONException e) {
            AccuratLogger.log(AccuratLogger.JSON_ERROR, e.getMessage());
        }

        return json;
    }

    public static UserActivity fromJson(String jsonString) {
        try {
            return new UserActivity(new JSONObject(jsonString));
        } catch (JSONException e) {
            AccuratLogger.log(AccuratLogger.JSON_ERROR, TAG + ".fromJson(): " + e.getMessage());

            return new UserActivity();
        }
    }
    // </editor-fold>
}