package ai.accurat.sdk.core;

public enum UserActivityType {
    IN_VEHICLE(0),
    ON_BICYCLE(1),
    ON_FOOT(2),
    STILL(3),
    UNKNOWN(4),
    TILTING(5),
    WALKING(7),
    RUNNING(8);

    private int apiValue;

    UserActivityType(int apiValue) {
        this.apiValue = apiValue;
    }

    public static UserActivityType fromApiValue(int apiValue) {
        for (UserActivityType type : values()) {
            if (type.apiValue == apiValue) {
                return type;
            }
        }

        return UNKNOWN;
    }
}
