package ai.accurat.sdk.core;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.LruCache;

import com.android.volley.RequestQueue;
import com.android.volley.toolbox.ImageLoader;
import com.android.volley.toolbox.Volley;

/**
 * @author Kenneth Saey
 * @since 01-08-2018 16:26.
 */
public class AccuratImageLoader {

    private static AccuratImageLoader INSTANCE;

    private ImageLoader imageLoader;

    private AccuratImageLoader(Context context) {
        RequestQueue requestQueue = Volley.newRequestQueue(context);
        imageLoader = new ImageLoader(requestQueue, new ImageLoader.ImageCache() {

            private final LruCache<String, Bitmap> cache = new LruCache<>(10);

            @Override
            public Bitmap getBitmap(String url) {
                return cache.get(url);
            }

            @Override
            public void putBitmap(String url, Bitmap bitmap) {
                cache.put(url, bitmap);
            }
        });
    }

    public static void init(Context context) {
        INSTANCE = new AccuratImageLoader(context);
    }

    public static AccuratImageLoader getInstance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("AccuratImageLoader has not yet been initialised.");
        }

        return INSTANCE;
    }

    public static ImageLoader getImageLoader() {
        return getInstance().imageLoader;
    }
}
