package ai.accurat.sdk.core;

import android.location.Location;

import java.util.concurrent.TimeUnit;

/**
 * Carbon copy of OpenLocateBasedEndpoint.LocationInfo.
 * Extracted for reuse when using different location tracking platforms.
 *
 * @since 2.0.0
 */
public class LocationInfo {

    private double latitude;
    private double longitude;
    private float horizontalAccuracy;
    private long timeStampSecs;
    private float speed;
    private float course;
    private double altitude;

    LocationInfo() { }

    LocationInfo(Location location) {
        latitude = location.getLatitude();
        longitude = location.getLongitude();
        horizontalAccuracy = location.getAccuracy();
        timeStampSecs = TimeUnit.MILLISECONDS.toSeconds(location.getTime());
        speed = location.getSpeed();
        course = location.getBearing();
        altitude = location.getAltitude();
    }

    public double getLatitude() {
        return latitude;
    }

    protected void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return longitude;
    }

    protected void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public double getHorizontalAccuracy() {
        return horizontalAccuracy;
    }

    protected void setHorizontalAccuracy(float horizontalAccuracy) {
        this.horizontalAccuracy = horizontalAccuracy;
    }

    long getTimeStampSecs() {
        return timeStampSecs;
    }

    protected void setTimeStampSecs(long timeStampSecs) {
        this.timeStampSecs = timeStampSecs;
    }

    float getSpeed() {
        return speed;
    }

    protected void setSpeed(float speed) {
        this.speed = speed;
    }

    float getCourse() {
        return course;
    }

    protected void setCourse(float course) {
        this.course = course;
    }

    double getAltitude() {
        return altitude;
    }

    protected void setAltitude(double altitude) {
        this.altitude = altitude;
    }

    @Override
    public String toString() {
        return "Location{" +
                "latitude=" + latitude +
                ", longitude=" + longitude +
                ", horizontalAccuracy=" + horizontalAccuracy +
                ", timeStampSecs=" + timeStampSecs +
                ", speed=" + speed +
                ", course=" + course +
                ", altitude=" + altitude +
                '}';
    }
}
