package ai.accurat.sdk.core;

import org.json.JSONException;
import org.json.JSONObject;

import ai.accurat.sdk.constants.StorageKeys;

public class TimeInterval extends JSON {

    // <editor-fold desc="Fields">
    private Day startDay;
    private int startHour;
    private Day endDay;
    private int endHour;
    // </editor-fold>

    // <editor-fold desc="Initialisation">
    public TimeInterval() {
    }

    public TimeInterval(Day startDay, int startHour, Day endDay, int endHour) {
        this.startDay = startDay;
        this.startHour = startHour;
        this.endDay = endDay;
        this.endHour = endHour;
    }

    public TimeInterval(Day startDay, int startHour, int endHour) {
        this.startDay = startDay;
        this.startHour = startHour;
        this.endHour = endHour;
    }
    // </editor-fold>

    // <editor-fold desc="JSON Handling">
    @Override
    public void update(JSONObject json) {
        startDay = load(json, StorageKeys.TimeInterval.START_DAY, startDay, Day.class);
        startHour = load(json, StorageKeys.TimeInterval.START_HOUR, startHour);
        endDay = load(json, StorageKeys.TimeInterval.END_DAY, endDay, Day.class);
        endHour = load(json, StorageKeys.TimeInterval.END_HOUR, endHour);
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = new JSONObject();

        try {
            json.put(StorageKeys.TimeInterval.START_DAY, startDay);
            json.put(StorageKeys.TimeInterval.START_HOUR, startHour);
            json.put(StorageKeys.TimeInterval.END_DAY, endDay);
            json.put(StorageKeys.TimeInterval.END_HOUR, endHour);
        } catch (JSONException e) {
            e.printStackTrace();
        }

        return json;
    }
    // </editor-fold>

    // <editor-fold desc="Public helpers">
    public boolean contains(Day day, int hour) {
        return contains(day) && contains(hour);
    }

    public boolean contains(Day day) {
        return (startDay == endDay && startDay == day)
                || (startDay.ordinal() <= day.ordinal() && day.ordinal() <= endDay.ordinal());
    }

    public boolean contains(int hour) {
        return (startHour == endHour && startHour == hour)
                || (startHour <= hour && hour <= endHour);

    }
    // </editor-fold>
}
