package ai.accurat.sdk.data.enums

/**
 * @author Kenneth
 * @since 2021-12-21
 */
enum class GeofenceType(
    val variants: List<String>,
) {
    ENTER(listOf("enter", "entry", "entered", "entering")),
    DWELL(listOf("dwell", "dwelled", "dwelling")),
    EXIT(listOf("exit", "exited", "exiting"));

    fun matches(type: String?): Boolean {
        return variants.map { variant ->
            variant.lowercase()
        }.contains(type?.lowercase())
    }
}