package ai.accurat.sdk.data.models;

import io.realm.RealmObject;
import io.realm.annotations.PrimaryKey;

public class Setting extends RealmObject {

    // <editor-fold desc="Fields">
    @PrimaryKey
    public String key;
    public String stringValue;
    public boolean booleanValue;
    public int intValue;
    public long longValue;
    // </editor-fold>

    // <editor-fold desc="Initialisation">
    public Setting() {
    }

    public Setting(String key, String value) {
        this.key = key;
        stringValue = value;
    }

    public Setting(String key, boolean value) {
        this.key = key;
        booleanValue = value;
    }

    public Setting(String key, int value) {
        this.key = key;
        intValue = value;
    }

    public Setting(String key, long value) {
        this.key = key;
        longValue = value;
    }
    // </editor-fold>

    public static final class RealmColumns {
        public static final String _TABLE = Setting.class.getSimpleName();

        public static final String KEY = "key";
        public static final String STRING_VALUE = "stringValue";
        public static final String BOOLEAN_VALUE = "booleanValue";
        public static final String INTEGER_VALUE = "integerValue";
        public static final String LONG_VALUE = "longValue";
    }

    public static final class Keys {
        public static final class Config {
            public static final String USERNAME = "config.username";
            public static final String PASSWORD = "config.password";
            public static final String NOTIFICATION_TARGET_PACKAGE = "config.notificationTargetPackage";
            public static final String NOTIFICATION_TARGET_CLASS = "config.notificationTargetClass";
            public static final String GDPR_CONSENT = "config.askGdprConsent";
            public static final String LOCATION_PERMISSION = "config.locationPermission";
            public static final String APP_VERSION = "config.appVersion";
            public static final String HAS_DEBUG_LOGS_ENABLED = "config.hasDebugLogsEnabled";
            public static final String APP_VERSION_CODE = "config.appVersionCode";
            public static final String FEATURE_SWITCHES = "config.featureSwitches";
        }

        public static final class State {
            public static final String START_REQUESTED = "state.startRequested";
            public static final String CONSENT_JSON = "state.consentJson";
            public static final String LAST_CONSENT_REQUEST_TIMESTAMP = "state.lastConsentRequestTimestamp";
            public static final String GEOFENCE_NOTIFICATION_LOG = "state.geofenceNotificationLog";
        }
    }

}
