package ai.accurat.sdk.core;

import android.content.Context;
import androidx.annotation.NonNull;

import androidx.work.Worker;
import androidx.work.WorkerParameters;

import ai.accurat.sdk.managers.RealmManager;

public class AccuratScheduleGeofenceNotificationsWorker extends Worker {

    private static final String TAG = AccuratScheduleGeofenceNotificationsWorker.class.getSimpleName();

    public AccuratScheduleGeofenceNotificationsWorker(@NonNull Context context, @NonNull WorkerParameters workerParams) {
        super(context, workerParams);
    }

    @NonNull
    @Override
    public Result doWork() {
        AccuratLogger.init(getApplicationContext());
        AccuratLogger.log(AccuratLogger.WORKMANAGER, TAG + ".doWork()");
        RealmManager.init(getApplicationContext());
        GeofenceNotificationManager.init(getApplicationContext());

        GeofenceNotificationManager.scheduleFetch();

        AccuratLogger.log(AccuratLogger.WORKMANAGER, TAG + " - Work done, returning Result.success()");
        return Result.success();
    }
}
