package ai.accurat.sdk.core;

import android.content.Context;
import android.location.Location;

import com.google.android.gms.ads.identifier.AdvertisingIdClient;

import ai.accurat.sdk.callbacks.AccuratProcessCallback;

/**
 * Interface for abstracting location tracking.
 */
public interface LocationTrackerInterface {

    /**
     * Should initialize the Location tracker.
     *
     * @param context Used for initializing the manager classes.
     */
    void initLocationTracking(Context context);

    /**
     * Should start tracking the location of the user.
     *
     * @param context  Used to access the required tracking mechanisms.
     * @param callback Callback which should tell the subscriber that location tracking has started successfully
     */
    void startLocationTracking(Context context, AccuratProcessCallback callback);

    /**
     * Stops tracking the location of the user.
     *
     * @param context Used to access the required tracking mechanisms.
     */
    void stopLocationTracking(Context context);

    /**
     * Compiles the device configuration at the moment of a location update.
     */
    LocationTrackerConfigurationInterface getConfiguration();

    /**
     * Transform a regular location object to Accurat's format.
     *
     * @param context         Context used to access local storage and device parameters.
     * @param location        Base location to transform.
     * @param advertisingInfo Advertising information fetched with {@link AdvertisingIdClient}.
     * @param userActivity    The estimated activity the user is performing.
     * @return The modified location object with contextual info required by the server.
     */
    LocationInterface transformLocation(Context context, Location location, AdvertisingIdClient.Info advertisingInfo, UserActivity userActivity);
}
