package ai.accurat.sdk.core;

import ai.accurat.sdk.config.Configuration;

/**
 * @author Kenneth Saey
 * @since 18-02-2019 13:22.
 */
public class LocationUtils {

    /**
     * Calculates the distance between two points on Earth and returns the result in meters.
     *
     * @param longitude1 Longitude of the first point
     * @param latitude1  Latitude of the first point
     * @param longitude2 Longitude of the second point
     * @param latitude2  Latitude of the second point
     * @return Distance between the points on Earth in meters
     */
    public static double distance(double longitude1, double latitude1, double longitude2, double latitude2) {
        if (longitude1 == longitude2 && latitude1 == latitude2) {
            return 0;
        }

        double phi1 = Math.toRadians(latitude1);
        double phi2 = Math.toRadians(latitude2);
        double deltaPhi = Math.toRadians(latitude2 - latitude1);
        double deltaLambda = Math.toRadians(longitude2 - longitude1);

        double haversine = Math.pow(Math.sin(deltaPhi / 2), 2)
                + Math.cos(phi1) * Math.cos(phi2)
                * Math.pow(Math.sin(deltaLambda / 2), 2);
        double angularDistance = 2 * Math.atan2(Math.sqrt(haversine), Math.sqrt(1 - haversine));// In Radians

        return Configuration.EARTH_AVERAGE_RADIUS_METERS * angularDistance;
    }
}
