package ai.accurat.sdk.core;

import android.os.Build;

/**
 * Factory class used to create the appropriate SearchBox.
 */
final class SearchBoxFactory {

    private SearchBoxFactory() {
    }

    /**
     * Creates a {@link SearchBoxInterface} depending on the OS version.
     */
    static SearchBoxInterface create(Double minLatitude, Double maxLatitude, Double minLongitude, Double maxLongitude) {
        return Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP
                ? new SearchBox(minLatitude, maxLatitude, minLongitude, maxLongitude)
                : new SearchBoxKitKat(minLatitude, maxLatitude, minLongitude, maxLongitude);
    }

}
