package ai.accurat.sdk.core;

import android.content.Context;
import androidx.annotation.NonNull;

import java.util.List;

import ai.accurat.sdk.managers.RealmManager;
import io.realm.ImportFlag;
import io.realm.Realm;
import io.realm.RealmModel;
import io.realm.RealmResults;

/***
 * This class provides very simple and straight-forward storage for Realm. Basically, it's a fetch all
 * and store one or more of a Realm model without any more bells and whistles.
 * @param <T>
 */
final class SimpleRealmStorage<T extends RealmModel> {

    private static final String TAG = SimpleRealmStorage.class.getSimpleName();

    public SimpleRealmStorage(@NonNull Context context) {
        RealmManager.init(context);
        AccuratLogger.init(context);
        AccuratLogger.log(AccuratLogger.SDK_FLOW, "Initialising " + TAG);
    }

    public List<T> getAll(Class<T> clazz) {
        AccuratLogger.log(AccuratLogger.METHOD_START, TAG + ".getAll()");

        Realm realm = RealmManager.getAccuratInstance();

        try {
            RealmResults<T> result = realm.where(clazz).findAll();
            return realm.copyFromRealm(result);
        } finally {
            realm.close();
            AccuratLogger.log(AccuratLogger.METHOD_END, TAG + ".getAll()");
        }
    }

    public T getFirst(Class<T> clazz) {
        AccuratLogger.log(AccuratLogger.METHOD_START, TAG + ".getFirst()");

        Realm realm = RealmManager.getAccuratInstance();

        try {
            return realm.where(clazz).findFirst();
        } finally {
            realm.close();
            AccuratLogger.log(AccuratLogger.METHOD_END, TAG + ".getFirst()");
        }
    }

    public void store(T object, ImportFlag... flags) {
        AccuratLogger.log(AccuratLogger.METHOD_START, TAG + ".store()");

        Realm realm = RealmManager.getAccuratInstance();

        try {
            realm.executeTransaction(
                    transactionRealm -> {
                        realm.copyToRealm(object, flags);
                    });
        } finally {
            realm.close();
            AccuratLogger.log(AccuratLogger.METHOD_END, TAG + ".store()");
        }
    }

    public void clearAll(Class<T> clazz) {
        AccuratLogger.log(AccuratLogger.METHOD_START, TAG + ".clearAll()");

        Realm realm = RealmManager.getAccuratInstance();

        try {
            realm.executeTransaction(
                    transactionRealm -> {
                        transactionRealm.delete(clazz);
                    });
        } finally {
            realm.close();
            AccuratLogger.log(AccuratLogger.METHOD_END, TAG + ".clearAll()");
        }
    }

}
