package ai.accurat.sdk.managers;

import android.content.Context;

import ai.accurat.sdk.core.AccuratLogger;
import ai.accurat.sdk.data.AccuratMigration;
import ai.accurat.sdk.data.AccuratSchemaModule;
import io.realm.Realm;
import io.realm.RealmConfiguration;

public class RealmManager {

    private static final String TAG = RealmManager.class.getSimpleName();
    private static final long SCHEMA_VERSION = 12;
    private static final String SCHEMA_NAME = "accurat.realm";
    private static RealmConfiguration realmConfiguration;

    public static void init(Context context) {
        if(realmConfiguration == null) {
            AccuratLogger.init(context);
            Realm.init(context);
            realmConfiguration = new RealmConfiguration.Builder()
                    .name(SCHEMA_NAME)
                    .schemaVersion(SCHEMA_VERSION)
                    .allowWritesOnUiThread(true)
                    .migration(new AccuratMigration())
                    .modules(new AccuratSchemaModule())
                    .build();
            AccuratLogger.log(AccuratLogger.SDK_FLOW, "Initialised " + TAG);
        }
    }

    public static Realm getAccuratInstance() {
        if (realmConfiguration == null) {
            throw new IllegalStateException("Can't get Accurat's Realm instance before calling RealmManager.init(Context)");
        }

        return Realm.getInstance(realmConfiguration);
    }

    public static void executeTransaction(Realm.Transaction transaction) {
        Realm realm = getAccuratInstance();
        realm.executeTransaction(transaction);
        realm.close();
    }
}
