package ai.accurat.sdk.managers;

import android.os.Build;

import androidx.annotation.NonNull;

public class VersionManager {
    public static boolean isBelowAndroid10() {
        return Build.VERSION.SDK_INT < Build.VERSION_CODES.Q;
    }

    public static boolean is11OrHigher() {
        return Build.VERSION.SDK_INT >= Build.VERSION_CODES.R;
    }

    public static void when10OrHigher(@NonNull Runnable runnable) {
        if (isBelowAndroid10()) {
            return;
        }

        runnable.run();
    }

    public static void whenBelow10(@NonNull Runnable runnable) {
        if (!isBelowAndroid10()) {
            return;
        }

        runnable.run();
    }

    public static void whenBelow10(@NonNull Runnable ifRunner, @NonNull Runnable elseRunner) {
        if (isBelowAndroid10()) {
            ifRunner.run();

            return;
        }

        elseRunner.run();
    }
}
