package ai.accurat.sdk.config;

import java.text.SimpleDateFormat;
import java.util.Locale;

import ai.accurat.sdk.constants.ApiKeys;
import ai.accurat.sdk.constants.BuildTypes;

/**
 * @Accurat
 */
public class Configuration {

    public static final SimpleDateFormat LOG_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.getDefault());

    // <editor-fold desc="Endpoint settings">
    public static final String AUTH_HEADER_NAME = "APIAuth-HMAC-SHA256";

    public static final String ACCURAT_API_DOMAIN = BuildTypes.is(BuildTypes.STAGING) ? "https://staging-app.accurat.ai" : "https://app.accurat.ai";
    public static final String ACCURAT_API_PATH = "api";
    public static final int ACCURAT_API_VERSION = 2;

    public static final String ENDPOINT_GET_SETTINGS = "settings";
    public static final String ENDPOINT_GET_APP_VERSION_SETTINGS = "settings/:" + ApiKeys.Url.APP_VERSION;
    public static final String ENDPOINT_GET_PARAMETERS = "parameters";
    public static final String ENDPOINT_GET_CONSENTS = "consents/:" + ApiKeys.Url.LANGUAGE_KEY + "/android";
    public static final String ENDPOINT_POST_CONSENT = "consent";
    public static final String ENDPOINT_GET_CONSENT = "consent/:" + ApiKeys.Url.AD_ID;
    public static final String ENDPOINT_POST_TRACK = "track";
    public static final String ENDPOINT_GET_CONSUMERS = "consumers/:" + ApiKeys.Url.AD_ID;
    public static final String ENDPOINT_POST_CONSUMERS = "consumers/:" + ApiKeys.Url.AD_ID;
    public static final String ENDPOINT_GET_GEOFENCES = "geofences";
    public static final String ENDPOINT_GET_GEOFENCES_STATE = "geofences/status";
    public static final String ENDPOINT_GET_GEOFENCES_NOTIFICATIONS = "geofences/:" + ApiKeys.Url.AD_ID + "/notifications/:" + ApiKeys.Url.LANGUAGE_KEY;
    public static final String ENDPOINT_POST_GEOFENCE_TRIGGER = "geofences/:" + ApiKeys.Url.AD_ID + "/trigger";
    public static final String ENDPOINT_POST_INTERACT = "consumers/:" + ApiKeys.Url.AD_ID + "/interact";
    public static final String ENDPOINT_POST_BATCH_INTERACT = "consumers/:" + ApiKeys.Url.AD_ID + "/interact";
    public static final String ENDPOINT_GET_SEGMENTS = "consumers/:" + ApiKeys.Url.AD_ID + "/segments";
    public static final String ENDPOINT_POST_GDPR_RIGHT = "rights/:" + ApiKeys.Url.AD_ID;
    public static final String ENDPOINT_GET_META = "consumers/:" + ApiKeys.Url.AD_ID + "/meta";

    public static final String DEFAULT_ENDPOINT_URL = ACCURAT_API_DOMAIN + "/" + ACCURAT_API_PATH + "/" + ACCURAT_API_VERSION + "/" + ENDPOINT_POST_TRACK;
    // </editor-fold>

    // <editor-fold desc="Networking">
    public static final int DEFAULT_TIMEOUT_MS = 30000;
    public static final int DEFAULT_MAX_RETRIES = 3;
    public static final float DEFAULT_BACKOFF_MULTIPLIER = 2.0f;
    public static final int SYNC_WINDOW_START_SECONDS = 0;// Midnight
    public static final int SYNC_WINDOW_END_SECONDS = 7 * 3600;// 7 AM
    // </editor-fold>

    // <editor-fold desc="Default settings">
    public static final boolean DEFAULT_SDK_ENABLED = true;
    public static final boolean DEFAULT_GEOFENCING_ENABLED = true;
    public static final long DEFAULT_LOCATION_INTERVAL = 600;// Every 10 minutes in seconds
    public static final long DEFAULT_FASTEST_LOCATION_INTERVAL = 60;// Every minute in seconds
    public static final long DEFAULT_TRANSMISSION_INTERVAL_IN_SECS = 3600;// Every hour in seconds
    public static final long DEFAULT_MAX_WAIT_TIME = 3600;// 1 hour in seconds
    public static final long DEFAULT_SMALLEST_DISPLACEMENT = 100;// 100 meter
    public static final long DEFAULT_LOCATION_RESTART_TIMEOUT = 21600;// 6 hours in seconds
    public static final int DEFAULT_CURRENT_GEOFENCE_RADIUS = 200;// 200 meter
    public static final int DEFAULT_MAX_NOTIFICATIONS_PER_DAY = 3;

    public static final String SDK_VERSION = "5.1.0";
    public static final boolean DEFAULT_LOGGING_ENABLED = true;
    public static final long MINIMUM_LOCATION_RESTART_TIMEOUT = 7200;// 2 hours in seconds
    // </editor-fold>

    // <editor-fold desc="Consents">
    public static final int API_CONSENT_VERSION = 201807;
    public static final int MAX_CONSENT_REFUSE_COUNT = 1;
    public static final int MAX_PERMISSION_REFUSE_COUNT = 1;
    public static final int MIN_CONSENT_REQUEST_HIATUS_IN_MILLISECONDS = (BuildTypes.RELEASE.equalsBuild() ? 50 * 3600 : 60) * 1000; // Every 50 hours for release builds and every minute for debug builds
    // </editor-fold>

    // <editor-fold desc="Geofencing">
    public static final double EARTH_AVERAGE_RADIUS_METERS = 6371008;
    public static final double EARTH_EQUATORIAL_RADIUS_METERS = 6378137;
    public static final double EARTH_POLE_RADIUS_METERS = 6356752;
    public static final double MAX_GEOFENCE_DWELL_DISTANCE_METERS = 500;
    public static final int MAX_MONITORED_GEOFENCE_COUNT = 100;
    public static final double DEFAULT_GEOFENCE_SEARCHBOX_WIDTH_METER = 2000;
    public static final double DEFAULT_GEOFENCE_SEARCHBOX_HEIGHT_METER = 2000;
    public static final double MIN_GEOFENCE_SEARCHBOX_WIDTH_METER = 250;
    public static final double MIN_GEOFENCE_SEARCHBOX_HEIGHT_METER = 250;
    public static final long DEFAULT_DWELL_SECONDS = 300;
    // </editor-fold>

    // <editor-fold desc="Notifications">
    public static final String DEFAULT_NOTIFICATION_COLOUR = "#000000";
    // </editor-fold>

    // <editor-fold desc="Campaign interaction">
    public static final long DEFAULT_CAMPAIGN_UPLOAD_INTERVAL_MILLIS = 300000;// 5 minutes
    // </editor-fold>
}
