package ai.accurat.sdk.constants;

/**
 * @author Kenneth Saey
 * @since 02-08-2018 10:30.
 */
public enum AccuratLanguage {

    NL("nl_BE"),
    FR("fr_BE"),
    EN("en_EN");

    private String code;

    AccuratLanguage(String code) {
        this.code = code;
    }

    public static AccuratLanguage fromLanguage(String language) {
        if (language == null || language.length() < 2) {
            throw new IllegalArgumentException("Unsupported language: " + language);
        }

        for (AccuratLanguage accuratLanguage : values()) {
            if (accuratLanguage.code.toLowerCase().startsWith(language.toLowerCase())) {
                return accuratLanguage;
            }
        }

        throw new IllegalArgumentException("Unsupported language: " + language);
    }

    public String getCode() {
        return code;
    }
}
