package ai.accurat.sdk.constants;

/**
 * Replaces OpenLocateLocation.Keys class to ensure location keys across location tracking implementations are consistent.
 *
 * @since 2.0.0
 */
public class AccuratLocationKeys {
    public static final String LATITUDE = "latitude";
    public static final String LONGITUDE = "longitude";
    public static final String HORIZONTAL_ACCURACY = "horizontal_accuracy";
    public static final String TIMESTAMP = "utc_timestamp";
    public static final String AD_ID = "ad_id";
    public static final String AD_OPT_OUT = "ad_opt_out";
    public static final String AD_TYPE = "id_type";

    public static final String COURSE = "course";
    public static final String SPEED = "speed";
    public static final String ALTITUDE = "altitude";

    public static final String IS_CHARGING = "is_charging";
    public static final String DEVICE_MANUFACTURER = "device_manufacturer";
    public static final String DEVICE_MODEL = "device_model";
    public static final String OPERATING_SYSTEM = "os_version";

    public static final String LOCATION_METHOD = "location_method";
    public static final String LOCATION_CONTEXT = "location_context";

    public static final String CARRIER_NAME = "carrier_name";
    public static final String CONNECTION_TYPE = "connection_type";
    public static final String WIFI_SSID = "wifi_ssid";
    public static final String WIFI_BSSID = "wifi_bssid";
    public static final String USER_ACTIVITY_TYPE = "user_activity_type";
    public static final String USER_ACTIVITY_CONFIDENCE = "user_activity_confidence";

    public static final String SDK_VERSION = "sdk_version";
    public static final String APP_VERSION = "app_version";
    public static final String APP_VERSION_CODE = "app_build_version";
}
