package ai.accurat.sdk.constants;

import ai.accurat.sdk.BuildConfig;

/**
 * @author Kenneth Saey
 * @since 02-08-2018 11:07.
 */
public enum BuildTypes {

    DEBUG("debug"),
    STAGING("staging"),
    INTERNAL("internal"),
    RELEASE("release");

    private String code;

    BuildTypes(String code) {
        this.code = code;
    }

    public String getCode() {
        return code;
    }

    public boolean equalsBuild() {
        return code.equals(BuildConfig.BUILD_TYPE);
    }

    public boolean notEqualsBuild() {
        return !equalsBuild();
    }

    public static boolean is(BuildTypes buildType) {
        return buildType.code.equals(BuildConfig.BUILD_TYPE);
    }
}
