package ai.accurat.sdk.constants;

/**
 * @author Kenneth Saey
 * @Accurat
 * @since 15-06-2018 15:02.
 */
public class StorageKeys {

    public static final String ACCURAT_STORAGE = "accurat_storage";
    public static final String ACCURAT_MULTI_PROCESS_STORAGE = "accurat_multi_process_storage";

    // <editor-fold desc="State">
    public static final String ACCURAT_GEOFENCES_STATUS = "accurat_last_geofence_version";
    // </editor-fold>

    // <editor-fold desc="Settings">
    public static final String ACCURAT_SETTINGS = "accurat_settings";
    public static final String ACCURAT_ENDPOINTS = "accurat_endpoints";
    public static final String ACCURAT_LOGGING_ENABLED = "accurat_logging_enabled";
    public static final String ACCURAT_GEOFENCES_NOTIFICATIONS_SYNC_MILLIS = "accurat_geofences_notifications_sync_millis";

    public static final String ACCURAT_SDK_ENABLED = "accurat_sdk_enabled";
    public static final String ACCURAT_GEOFENCING_ENABLED = "accurat_geofencing_enabled";
    public static final String ACCURAT_LOCATION_INTERVAL = "accurat_location_interval";
    public static final String ACCURAT_FASTEST_LOCATION_INTERVAL = "accurat_fastest_location_interval";
    public static final String ACCURAT_TRANSMISSION_INTERVAL = "accurat_transmission_interval";
    public static final String ACCURAT_MAX_WAIT_TIME = "accurat_max_wait_time";
    public static final String ACCURAT_SMALLEST_DISPLACEMENT = "accurat_smallest_displacement";
    public static final String ACCURAT_LOCATION_RESTART_TIMEOUT = "accurat_location_restart_timeout";
    // </editor-fold>

    // <editor-fold desc="Data">
    public static final String ACCURAT_ADVERTISING_INFO = "accurat_advertising_info";
    // </editor-fold>

    // <editor-fold desc="Consent">
    public static final String ACCURAT_CONSENTS = "accurat_consents";
    // </editor-fold>

    // <editor-fold desc="User">
    public static final String ACCURAT_USER = "accurat_user";
    public static final String CLIENT_NOTIFICATION_DRAWABLE_ID = "client_notification_icon";
    public static final String ACCURAT_LAST_NOTIFICATION_ID = "last_notification_id";
    public static final String ACCURAT_CURRENT_GEOFENCE_RADIUS = "current_geofence_radius";
    public static final String ACCURAT_MAX_NOTIFICATIONS_PER_DAY = "max_notifications_per_day";
    public static final String ACCURAT_MAX_CONSENT_REFUSE_COUNT = "max_consent_refuse_count";
    public static final String ACCURAT_MAX_PERMISSION_REFUSE_COUNT = "max_permission_refuse_count";
    public static final String CACHED_USER = "cached_user";

    public static final class AccuratUser {
        public static final String LANGUAGE = "language";
    }
    // </editor-fold>

    //<editor-fold desc="Geofences">
    public static final String ACCURAT_GEOFENCES_LAST_TRIGGER = "last_triggered_geofence";
    public static final String ACCURAT_GEOFENCES_LAST_TRIGGER_TIMESTAMP = "last_triggered_geofence_timestamp";
    public static final String ACCURAT_GEOFENCES_META = "accurat_geofences_meta";
    public static final String ACCURAT_GEOFENCES_CURRENT = "accurat_geofences_current";
    public static final String ACCURAT_CUSTOM_GEOFENCES_LAST_LOCATION = "accurat_custom_geofences_last_location";
    public static final String ACCURAT_CUSTOM_MONITORED_GEOFENCES = "accurat_custom_monitored_geofences";
    public static final String ACCURAT_CUSTOM_META_GEOFENCE = "accurat_custom_meta_geofence";
    //</editor-fold>

    // <editor-fold desc="TimeInterval">
    public static final class TimeInterval {
        public static final String START_DAY = "startDay";
        public static final String START_HOUR = "startHour";
        public static final String END_DAY = "endDay";
        public static final String END_HOUR = "endHour";

        public static final class Server {
            public static final String DAY = "day";
            public static final String HOURS = "hours";
        }
    }
    // </editor-fold>

    // <editor-fold desc="GeofenceNotificationManager">
    public static final String ACCURAT_GEOFENCE_NOTIFICATIONS = "accurat_geofence_notifications";
    // </editor-fold>

    // <editor-fold desc="GeofenceNotification">
    public static final class GeofenceNotification {
        public static final String NOTIFICATION_ID = "notification_id";
        public static final String DATA = "data";
        public static final String TITLE = "title";
        public static final String MESSAGE = "message";
        public static final String BRAND_COLOUR = "brand_colour";
        public static final String FREQUENCY = "frequency";
        public static final String TIME_INTERVALS = "time_intervals";

        public static final class Server {
            public static final String NOTIFICATION_ID = "nid";
            public static final String DATA = "data";
            public static final String TITLE = "title";
            public static final String MESSAGE = "message";
            public static final String BRAND_COLOUR = "brand_color";
            public static final String FREQUENCY = "frequency";
            public static final String TIME_INTERVALS = "timings";
        }
    }
    // </editor-fold>

    // <editor-fold desc="GeofenceNotificationLog">
    public static final class GeofenceNotificationLog {
        public static final String NOTIFICATION_ID = "nid";
        public static final String COUNT = "count";
    }
    // </editor-fold>

    // <editor-fold desc="UserActivity">
    public static final String USER_ACTIVITY = "user_activity";

    public static final class UserActivity {
        public static final String TYPE = "type";
        public static final String CONFIDENCE = "confidence";
    }
    // </editor-fold>

    // <editor-fold desc="GeofenceLocation">
    public static final class GeofenceLocation {
        public static final String PROVIDER = "provider";
        public static final String TIMESTAMP = "timestamp";
        public static final String LATITUDE = "latitude";
        public static final String LONGITUDE = "longitude";
        public static final String ALTITUDE = "altitude";
        public static final String SPEED = "speed";
        public static final String BEARING = "bearing";
        public static final String HORIZONTAL_ACCURACY = "horizontal_accuracy";
        public static final String VERTICAL_ACCURACY = "vertical_accuracy";
        public static final String SPEED_ACCURACY = "speed_accuracy";
        public static final String BEARING_ACCURACY = "bearing_accuracy";
    }
    // </editor-fold>

    // <editor-fold desc="Campaign interactions">
    public static final String CAMPAIGN_INTERACTIONS = "campaign_interactions";
    public static final String CAMPAIGN_LAST_UPLOAD = "campaign_last_upload";
    // </editor-fold>
}
