package ai.accurat.sdk.core;

import android.content.Context;
import androidx.annotation.NonNull;

import androidx.work.Worker;
import androidx.work.WorkerParameters;

import ai.accurat.sdk.managers.RealmManager;

/**
 * Will plan a periodic synchronisation after initialising the {@link AccuratSettingsManager}
 *
 * @author Kenneth Saey
 * @since 02-07-2018 15:15.
 *
 * @Accurat
 */
public class AccuratScheduleSettingsWorker extends Worker {

    private static final String TAG = AccuratScheduleSettingsWorker.class.getSimpleName();

    public AccuratScheduleSettingsWorker(@NonNull Context context, @NonNull WorkerParameters workerParams) {
        super(context, workerParams);
    }

    @NonNull
    @Override
    public Result doWork() {
        AccuratLogger.init(getApplicationContext());
        AccuratLogger.log(AccuratLogger.WORKMANAGER, TAG + ".doWork()");
        RealmManager.init(getApplicationContext());
        AccuratSettingsManager.init(getApplicationContext());

        AccuratSettingsManager.scheduleFetch();

        AccuratLogger.log(AccuratLogger.WORKMANAGER, TAG + " - Work done, returning Result.success()");
        return Result.success();
    }
}
