package ai.accurat.sdk.core;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;

import androidx.annotation.RequiresApi;

import ai.accurat.sdk.Accurat;
import ai.accurat.sdk.data.models.ConsentManagerState;
import ai.accurat.sdk.managers.RealmManager;

public class BootCompleteReceiver extends BroadcastReceiver {

    private static final String TAG = BootCompleteReceiver.class.toString();

    @RequiresApi(api = Build.VERSION_CODES.KITKAT)
    @Override
    public void onReceive(Context context, Intent intent) {
        AccuratLogger.init(context);
        AccuratLogger.log(AccuratLogger.SDK_FLOW, TAG + ".onReceive()");
        initTracking(context);
    }

    @RequiresApi(api = Build.VERSION_CODES.KITKAT)
    private void initTracking(Context context) {
        RealmManager.init(context);
        if (!ConsentManagerState.Companion.isStartRequested()) {
            AccuratLogger.log(AccuratLogger.SDK_FLOW, "No need to restart Accurat after reboot, no start requested");

            return;
        }
        AccuratLogger.log(AccuratLogger.SDK_FLOW, "Restarting Accurat after reboot");

        try {
            Accurat.initialize(context.getApplicationContext());
            Accurat.startAfterReboot(context.getApplicationContext());
        } catch (IllegalStateException e) {
            AccuratLogger.log(AccuratLogger.JSON_ERROR, TAG + ".initTracking(): " + e.getMessage());
            e.printStackTrace();
        }
    }
}