package ai.accurat.sdk.core;

import android.app.Activity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import ai.accurat.sdk.constants.ConsentState;
import ai.accurat.sdk.constants.ConsentType;

/**
 * @author Kenneth Saey
 * @since 25-06-2018 10:01.
 *
 * @Accurat
 */
public class ConsentFlow {

    public Activity activity;
    public ConsentType[] consentTypes;
    public ConsentResponse consentResponse;
    public HashMap<ConsentType, ConsentState> handledConsentTypes = new HashMap<>();
    public int index = 0;

    public ConsentFlow(Activity activity, ConsentType[] consentTypes, ConsentResponse consentResponse) {
        this.activity = activity;
        this.consentTypes = consentTypes;
        this.consentResponse = consentResponse;
    }

    public boolean hasMore() {
        return index < consentTypes.length;
    }

    public ConsentFlow getNext() {
        index++;

        return this;
    }

    public ConsentType getConsentType() {
        if (hasMore()) {
            return consentTypes[index];
        }

        return null;
    }

    public void setConsentState(ConsentType consentType, ConsentState consentState) {
        handledConsentTypes.put(consentType, consentState);
    }

    public void respond() {
        if (consentResponse == null) {
            return;
        }

        List<ConsentType> approvedConsents = new ArrayList<>();
        for (ConsentType consentType : handledConsentTypes.keySet()) {
            if (handledConsentTypes.get(consentType) == ConsentState.ACCEPTED) {
                approvedConsents.add(consentType);
            }
        }
        consentResponse.onConsentsAnswered(approvedConsents.toArray(new ConsentType[0]));
    }
}
