package ai.accurat.sdk.core;

import android.location.Location;
import android.os.Build;

import org.json.JSONException;
import org.json.JSONObject;

import ai.accurat.sdk.constants.StorageKeys;

public class GeofenceLocation extends JSON {

    // <editor-fold desc="Properties">
    private static final String TAG = GeofenceLocation.class.getSimpleName();

    public String provider;
    public long timestamp;
    public double latitude;
    public double longitude;
    public double altitude;
    public float speed;
    public float bearing;
    public float horizontalAccuracy;
    public float verticalAccuracy;
    public float speedAccuracy;
    public float bearingAccuracy;
    // </editor-fold>

    // <editor-fold desc="Initialisation">
    public GeofenceLocation() {
    }

    public GeofenceLocation(Location location) {
        provider = location.getProvider();
        timestamp = location.getTime();
        latitude = location.getLatitude();
        longitude = location.getLongitude();
        altitude = location.getAltitude();
        speed = location.getSpeed();
        bearing = location.getBearing();
        horizontalAccuracy = location.getAccuracy();
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            verticalAccuracy = location.getVerticalAccuracyMeters();
            speedAccuracy = location.getSpeedAccuracyMetersPerSecond();
            bearingAccuracy = location.getBearingAccuracyDegrees();
        }
    }

    public static GeofenceLocation fromJson(String json) {
        if(json == null) {
            return null;
        }

        try {
            GeofenceLocation geofenceLocation = new GeofenceLocation();
            geofenceLocation.update(new JSONObject(json));

            return geofenceLocation;
        } catch (JSONException e) {
            AccuratLogger.log(AccuratLogger.JSON_ERROR, TAG + ".fromJson(): " + e.getMessage());

            return null;
        }
    }
    // </editor-fold>

    // <editor-fold desc="JSON Handling">
    @Override
    public void update(JSONObject json) {
        provider = load(json, StorageKeys.GeofenceLocation.PROVIDER, provider);
        timestamp = load(json, StorageKeys.GeofenceLocation.TIMESTAMP, timestamp);
        latitude = load(json, StorageKeys.GeofenceLocation.LATITUDE, latitude);
        longitude = load(json, StorageKeys.GeofenceLocation.LONGITUDE, longitude);
        altitude = load(json, StorageKeys.GeofenceLocation.ALTITUDE, altitude);
        speed = load(json, StorageKeys.GeofenceLocation.SPEED, speed);
        bearing = load(json, StorageKeys.GeofenceLocation.BEARING, bearing);
        horizontalAccuracy = load(json, StorageKeys.GeofenceLocation.HORIZONTAL_ACCURACY, horizontalAccuracy);
        verticalAccuracy = load(json, StorageKeys.GeofenceLocation.VERTICAL_ACCURACY, verticalAccuracy);
        speedAccuracy = load(json, StorageKeys.GeofenceLocation.SPEED_ACCURACY, speedAccuracy);
        bearingAccuracy = load(json, StorageKeys.GeofenceLocation.BEARING_ACCURACY, bearingAccuracy);
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        try {
            json.put(StorageKeys.GeofenceLocation.PROVIDER, provider);
            json.put(StorageKeys.GeofenceLocation.TIMESTAMP, timestamp);
            json.put(StorageKeys.GeofenceLocation.LATITUDE, latitude);
            json.put(StorageKeys.GeofenceLocation.LONGITUDE, longitude);
            json.put(StorageKeys.GeofenceLocation.ALTITUDE, altitude);
            json.put(StorageKeys.GeofenceLocation.SPEED, speed);
            json.put(StorageKeys.GeofenceLocation.BEARING, bearing);
            json.put(StorageKeys.GeofenceLocation.HORIZONTAL_ACCURACY, horizontalAccuracy);
            json.put(StorageKeys.GeofenceLocation.VERTICAL_ACCURACY, verticalAccuracy);
            json.put(StorageKeys.GeofenceLocation.SPEED_ACCURACY, speedAccuracy);
            json.put(StorageKeys.GeofenceLocation.BEARING_ACCURACY, bearingAccuracy);
        } catch (JSONException e) {
            AccuratLogger.log(AccuratLogger.JSON_ERROR, TAG + ".toJson(): " + e.getMessage());
            e.printStackTrace();
        }

        return json;
    }
    // </editor-fold>
}
