package ai.accurat.sdk.core;

import android.content.Context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class LocationTrackerConfigurationImpl implements LocationTrackerConfigurationInterface {

    Context context;
    private ArrayList<OpenLocateBasedEndpoint> endpoints;

    private boolean isWifiCollectionDisabled;
    private boolean isDeviceModelCollectionDisabled;
    private boolean isDeviceManufacturerCollectionDisabled;
    private boolean isOperatingSystemCollectionDisbaled;
    private boolean isChargingInfoCollectionDisabled;
    private boolean isCarrierNameCollectionDisabled;
    private boolean isConnectionTypeCollectionDisabled;
    private boolean isLocationMethodCollectionDisabled;
    private boolean isLocationContextCollectionDisabled;

    public LocationTrackerConfigurationImpl(Builder builder) {
        this.context = builder.context;
        this.endpoints = builder.endpoints;
        this.isCarrierNameCollectionDisabled = builder.isCarrierNameCollectionDisabled;
        this.isChargingInfoCollectionDisabled = builder.isChargingInfoCollectionDisabled;
        this.isConnectionTypeCollectionDisabled = builder.isConnectionTypeCollectionDisabled;
        this.isDeviceManufacturerCollectionDisabled = builder.isDeviceManufacturerCollectionDisabled;
        this.isDeviceModelCollectionDisabled = builder.isDeviceModelCollectionDisabled;
        this.isLocationContextCollectionDisabled = builder.isLocationContextCollectionDisabled;
        this.isLocationMethodCollectionDisabled = builder.isLocationMethodCollectionDisabled;
        this.isOperatingSystemCollectionDisbaled = builder.isOperatingSystemCollectionDisbaled;
        this.isWifiCollectionDisabled = builder.isWifiCollectionDisabled;
    }

    @Override
    public List<OpenLocateBasedEndpoint> getEndpoints() {
        return this.endpoints;
    }

    @Override
    public boolean isWifiCollectionDisabled() {
        return this.isWifiCollectionDisabled;
    }

    @Override
    public boolean isDeviceModelCollectionDisabled() {
        return this.isDeviceModelCollectionDisabled;
    }

    @Override
    public boolean isDeviceManufacturerCollectionDisabled() {
        return this.isDeviceManufacturerCollectionDisabled;
    }

    @Override
    public boolean isOperaringSystemCollectionDisbaled() {
        return this.isOperatingSystemCollectionDisbaled;
    }

    @Override
    public boolean isChargingInfoCollectionDisabled() {
        return this.isChargingInfoCollectionDisabled;
    }

    @Override
    public boolean isCarrierNameCollectionDisabled() {
        return this.isCarrierNameCollectionDisabled;
    }

    @Override
    public boolean isConnectionTypeCollectionDisabled() {
        return this.isConnectionTypeCollectionDisabled;
    }

    @Override
    public boolean isLocationMethodCollectionDisabled() {
        return this.isLocationMethodCollectionDisabled;
    }

    @Override
    public boolean isLocationContextCollectionDisabled() {
        return this.isLocationContextCollectionDisabled;
    }

    static final class Builder implements LocationTrackerConfigurationInterface.BuilderInterface {

        private Context context;
        private ArrayList<OpenLocateBasedEndpoint> endpoints;
        private String serverUrl;
        private HashMap<String, String> headers;
        private boolean isWifiCollectionDisabled;
        private boolean isDeviceModelCollectionDisabled;
        private boolean isDeviceManufacturerCollectionDisabled;
        private boolean isOperatingSystemCollectionDisbaled;
        private boolean isChargingInfoCollectionDisabled;
        private boolean isCarrierNameCollectionDisabled;
        private boolean isConnectionTypeCollectionDisabled;
        private boolean isLocationMethodCollectionDisabled;
        private boolean isLocationContextCollectionDisabled;

        public Builder(Context context, ArrayList<OpenLocateBasedEndpoint> endpoints) {
            this.context = context.getApplicationContext();
            this.endpoints = endpoints;
        }

        public Builder(Context context, String serverUrl) {
            this.context = context.getApplicationContext();
            this.serverUrl = serverUrl;
        }

        @Override
        public Builder setHeaders(HashMap<String, String> headers) {
            this.headers = headers;
            return this;
        }

        @Override
        public Builder withoutWifiInfo() {
            this.isWifiCollectionDisabled = true;
            return this;
        }

        @Override
        public Builder withoutDeviceModel() {
            this.isDeviceModelCollectionDisabled = true;
            return this;
        }

        @Override
        public Builder withoutDeviceManufacturer() {
            this.isDeviceManufacturerCollectionDisabled = true;
            return this;
        }

        @Override
        public Builder withoutOperatingSystem() {
            this.isOperatingSystemCollectionDisbaled = true;
            return this;
        }

        @Override
        public Builder withoutChargingInfo() {
            this.isChargingInfoCollectionDisabled = true;
            return this;
        }

        @Override
        public Builder withoutCarrierName() {
            this.isCarrierNameCollectionDisabled = true;
            return this;
        }

        @Override
        public Builder withoutConnectionType() {
            this.isConnectionTypeCollectionDisabled = true;
            return this;
        }

        @Override
        public Builder withoutLocationMethod() {
            this.isLocationMethodCollectionDisabled = true;
            return this;
        }

        @Override
        public Builder withoutLocationContext() {
            this.isLocationContextCollectionDisabled = true;
            return this;
        }

        @Override
        public LocationTrackerConfigurationInterface build() {
            if (serverUrl != null) {
                OpenLocateBasedEndpoint endpoint = new OpenLocateBasedEndpoint(serverUrl, headers);

                if (endpoints == null) {
                    endpoints = new ArrayList<>();
                }

                endpoints.add(endpoint);
            }

            return new LocationTrackerConfigurationImpl(this);
        }
    }
}
