package ai.accurat.sdk.core;

import java.util.HashMap;
import java.util.List;

/**
 * Interface extracted from OpenLocate.Configuration to guarantee data consistency across versions.
 * Represents extra info attached to locations that will be sent to the server.
 *
 * @since 2.0.0
 */
interface LocationTrackerConfigurationInterface {

    List<OpenLocateBasedEndpoint> getEndpoints();

    boolean isWifiCollectionDisabled();

    boolean isDeviceModelCollectionDisabled();

    boolean isDeviceManufacturerCollectionDisabled();

    boolean isOperaringSystemCollectionDisbaled();

    boolean isChargingInfoCollectionDisabled();

    boolean isCarrierNameCollectionDisabled();

    boolean isConnectionTypeCollectionDisabled();

    boolean isLocationMethodCollectionDisabled();

    boolean isLocationContextCollectionDisabled();

    interface BuilderInterface {
        BuilderInterface setHeaders(HashMap<String, String> headers);

        BuilderInterface withoutWifiInfo();

        BuilderInterface withoutDeviceModel();

        BuilderInterface withoutDeviceManufacturer();

        BuilderInterface withoutOperatingSystem();

        BuilderInterface withoutChargingInfo();

        BuilderInterface withoutCarrierName();

        BuilderInterface withoutConnectionType();

        BuilderInterface withoutLocationMethod();

        BuilderInterface withoutLocationContext();

        LocationTrackerConfigurationInterface build();
    }
}
