package ai.accurat.sdk.core;

import android.content.Context;

/**
 * Wrapper class which can be used to keep the location and a relevant context together.
 * Might be necessary when database access is required on another thread to perform calculations on the Location object.
 */
public class LocationUpdateWrapper {

    private Context context;
    private LocationInterface location;
    private boolean updateMetaFencesOnly;

    public LocationUpdateWrapper(Context context, LocationInterface location) {
        this(context, location, false);
    }

    public LocationUpdateWrapper(Context context, LocationInterface location, boolean updateMetaFencesOnly) {
        this.context = context;
        this.location = location;
        this.updateMetaFencesOnly = updateMetaFencesOnly;
    }

    public Context getContext() {
        return context;
    }

    public LocationInterface getLocation() {
        return location;
    }

    public boolean isUpdateMetaFencesOnly() {
        return updateMetaFencesOnly;
    }
}
