package ai.accurat.sdk.data.enums

/**
 * @author Kenneth
 * @since 2020-11-10
 */
enum class ConsentFlowState {
    NONE,
    STARTED,
    CHECKING_AD_ID,
    FETCHING_CONSENT_MODELS,
    FETCHING_USER_CONSENTS,
    CHECKING_CONSENTS,
    ANDROID_BELOW_10_LOCATION_PERMISSION_REQUESTED,
    ANDROID_10_LOCATION_PERMISSION_REQUESTED,
    ANDROID_ABOVE_10_FOREGROUND_LOCATION_PERMISSION_REQUESTED,
    ANDROID_ABOVE_10_BACKGROUND_LOCATION_PERMISSION_REQUESTED,
    UPLOADING_USER_CONSENTS,
    FINISHED;

    companion object {
        fun from(name: String): ConsentFlowState = values().first {
            it.name == name
        }
    }
}