package ai.accurat.sdk.core;

import android.location.Location;

import com.google.android.gms.ads.identifier.AdvertisingIdClient;

import java.util.Date;

/**
 * Generic location builder interface which should be used independently of the location tracking platform.
 * Contains methods to assemble contextual information of a location.
 * These data points will be compiled into an appropriate location object, which should in turn implement {@link LocationInterface}.
 *
 * @since 2.0.0
 */
public interface AccuratLocationBuilderInterface {

    AccuratLocationBuilderInterface setDate(Date date);

    AccuratLocationBuilderInterface setLocation(Location location);

    AccuratLocationBuilderInterface setLocationInfo(LocationInfo locationInfo);

    AccuratLocationBuilderInterface setAdvertisingInfo(AdvertisingIdClient.Info advertisingInfo);

    AccuratLocationBuilderInterface setInformationFields(InformationFields informationFields);

    AccuratLocationBuilderInterface setUserActivity(UserActivity userActivity);

    AccuratLocationBuilderInterface setJsonRepresentation(String jsonRepresentation);

}
