package ai.accurat.sdk.core;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Locale;

import ai.accurat.sdk.constants.AccuratLanguage;
import ai.accurat.sdk.constants.StorageKeys;

/**
 * @author Kenneth Saey
 * <p>
 * This class stores data specific to Accurat's concept of a user.
 * For now it stores the user's language, in the future it might store things like the user's
 * notification id.
 * @Accurat
 * @since 06-08-2018 15:24.
 */
public class AccuratUser {

    // </editor-fold>
    private static final String TAG = AccuratUser.class.getSimpleName();
    AccuratLanguage language = AccuratLanguage.EN;
    // <editor-fold desc="Fields">

    // <editor-fold desc="Construction">
    public AccuratUser() {
        try {
            language = AccuratLanguage.fromLanguage(Locale.getDefault().getLanguage());
        } catch (IllegalArgumentException ignored) {
        }
    }
    // </editor-fold>

    // <editor-fold desc="Serialisation">
    public static AccuratUser fromJson(String jsonString) throws JSONException {
        return fromJson(new JSONObject(jsonString));
    }

    public static AccuratUser fromJson(JSONObject json) {
        AccuratUser user = new AccuratUser();

        try {
            user.language = json.has(StorageKeys.AccuratUser.LANGUAGE) ? AccuratLanguage.valueOf(json.getString(StorageKeys.AccuratUser.LANGUAGE)) : user.language;
        } catch (JSONException e) {
            AccuratLogger.log(AccuratLogger.JSON_ERROR, TAG + ".getJson(): " + e.getMessage());
            e.printStackTrace();
        }

        return user;
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();

        try {
            json.put(StorageKeys.AccuratUser.LANGUAGE, language.toString());
        } catch (JSONException e) {
            AccuratLogger.log(AccuratLogger.JSON_ERROR, TAG + ".toJson(): " + e.getMessage());
            e.printStackTrace();
        }

        return json;
    }
    // </editor-fold>

    // <editor-fold desc="Getters">
    public AccuratLanguage getLanguage() {
        return language;
    }
    // </editor-fold>

    // <editor-fold desc="Setters">
    public void setLanguage(AccuratLanguage language) {
        this.language = language;
    }
    // </editor-fold>
}
