package ai.accurat.sdk.core;

import java.util.List;

/**
 * Model class to keep the result and parameters of a selection of geofences based on a location.
 */
class GeofenceSelection {

    private final LocationInterface currentLocation;
    private List<AccuratGeofence> geofences;
    private AccuratGeofenceRange box;
    private long durationInMs;
    private int numIterations;

    public GeofenceSelection(LocationInterface location, List<AccuratGeofence> geofences, AccuratGeofenceRange box, int numIterations) {
        this.currentLocation = location;
        this.geofences = geofences;
        this.box = box;
        this.numIterations = numIterations;
    }

    /**
     * @return Location this selection is based on.
     */
    public LocationInterface getCurrentLocation() {
        return currentLocation;
    }

    /**
     * @return List of selected geofences
     */
    public List<AccuratGeofence> getGeofences() {
        return geofences;
    }

    /**
     * @return Box used to select geofences in
     */
    public AccuratGeofenceRange getBox() {
        return box;
    }

    /**
     * @return The time it took to find these geofences and box in ms
     */
    public long getDurationInMs() {
        return durationInMs;
    }

    /**
     * @return The number of iterations it took to find everything
     */
    public int getNumIterations() {
        return numIterations;
    }

    /**
     * @param durationInMs The time it took to find these geofences and box in ms
     */
    public void setDurationInMs(long durationInMs) {
        this.durationInMs = durationInMs;
    }

}
