package ai.accurat.sdk.core;

import android.app.ActivityManager;

import java.util.HashMap;
import java.util.Map;

import static android.app.ActivityManager.RunningAppProcessInfo.IMPORTANCE_FOREGROUND;
import static android.app.ActivityManager.RunningAppProcessInfo.IMPORTANCE_VISIBLE;

/**
 * @Both
 */
public enum LocationContext {

    UNKOWN("unknown"),
    FGROUND("fground"),
    BGROUND("bground"),
    GEOFENCE_ENTER("geofence_entry"),
    GEOFENCE_DWELL("geofence_dwell"),
    GEOFENCE_EXIT("geofence_exit"),
    GOOGLE_FUSED("fused_location"),
    GOOGLE_FUSED_BACKGROUND("fused_location_background"),
    OTHER("other");

    private final String value;

    private static final Map<String, LocationContext> lookup = new HashMap<>();

    static {
        for (LocationContext context : LocationContext.values()) {
            lookup.put(context.getValue(), context);
        }
    }

    LocationContext(final String value) {
        this.value = value;
    }

    String getValue() {
        return value;
    }

    public static LocationContext get(String value) {
        return lookup.get(value);
    }


    static boolean isForeground() {
        ActivityManager.RunningAppProcessInfo appProcessInfo = new ActivityManager.RunningAppProcessInfo();
        ActivityManager.getMyMemoryState(appProcessInfo);
        return (appProcessInfo.importance == IMPORTANCE_FOREGROUND || appProcessInfo.importance == IMPORTANCE_VISIBLE);
    }

    public static LocationContext getLocationContext() {
        return isForeground() ? LocationContext.GOOGLE_FUSED : LocationContext.GOOGLE_FUSED_BACKGROUND;
    }
}
