package ai.accurat.sdk.core;

import android.content.Context;

import com.google.android.gms.common.GoogleApiAvailability;

/**
 * Utility functions to access the Google Play Services API.
 */
public final class PlayServicesUtils {

    private PlayServicesUtils() {
    }

    /**
     * Check whether the Google Play Services are up to date.
     *
     * @param context Context to use for Google Play Services interaction.
     * @return int that indicates Google Play Services availability and whether an update is required.
     */
    public static int isGooglePlayServicesAvailable(final Context context) {
        GoogleApiAvailability apiAvailability = GoogleApiAvailability.getInstance();
        return apiAvailability.isGooglePlayServicesAvailable(context);
    }
}
