package ai.accurat.sdk.data.enums

import android.Manifest
import android.os.Build

/**
 * @author Kenneth
 * @since 2020-11-10
 */
enum class ConsentType(
    val value: String,
    val isPermission: Boolean,
    val systemPermissions: Array<String> = arrayOf()
) {
    UNKNOWN("unknown", false),
    GDPR("gdpr", false),
    IN_APP_LOCATION(
        "inapp_permission",
        true,
        arrayOf(
            Manifest.permission.ACCESS_COARSE_LOCATION,
            Manifest.permission.ACCESS_FINE_LOCATION
        )
    ),
    ALWAYS_LOCATION(
        "always_permission",
        true,
        arrayOf(
            Manifest.permission.ACCESS_COARSE_LOCATION,
            Manifest.permission.ACCESS_FINE_LOCATION
        ) + if (Build.VERSION.SDK_INT == Build.VERSION_CODES.Q) {
            arrayOf(Manifest.permission.ACCESS_BACKGROUND_LOCATION)
        } else arrayOf()
    ),
    ANDROID_11_ALWAYS_LOCATION(
        "background_permission",
        true,
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
            arrayOf(Manifest.permission.ACCESS_BACKGROUND_LOCATION)
        } else arrayOf()
    ),
    PRECISE_PERMISSION(
            "precise_permission",
            true,
            arrayOf(
                    Manifest.permission.ACCESS_COARSE_LOCATION,
                    Manifest.permission.ACCESS_FINE_LOCATION
            )
    );

    companion object {
        fun from(name: String): ConsentType = values().first {
            it.name == name
        }

        fun fromValue(value: String): ConsentType = values().find {
            it.value == value
        } ?: UNKNOWN
    }
}